% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareBaseline.R
\name{prepareBaseline}
\alias{prepareBaseline}
\title{Build baseline signal}
\usage{
prepareBaseline(x, year.start = NULL, year.end = NULL,
  window.20 = FALSE)
}
\arguments{
\item{x}{streamflow object, as output from the \code{asStreamflow()} function}

\item{year.start}{Start of the year for estimating baseline, or \code{NULL} to interpret this from input data}

\item{year.end}{End of the year for estimating baseline, or \code{NULL} to interpret this from input data}

\item{window.20}{If \code{TRUE}, baseline is constructed using windowing (20 year windows) and bootstrapping. 
If \code{FALSE}, baseline is constructed for a single run between start and end year.}
}
\value{
\code{ssignal} object containing the baseline signal
}
\description{
Runs fourier analysis on the input signal, to build baseline signal.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# baseline for single run for all the years in input signal
bl.singlerun.all = prepareBaseline(x.streamflow)

# baseline for singlerun between the given start and end years
bl.singlerun.filtered = prepareBaseline(x.streamflow, year.start = 1961, 
                                         year.end = 2000)

# baseline with windowinng and bootstrapping on all years in the input signal
bl.windowed.all = prepareBaseline(x.streamflow, window.20 = TRUE)

# baseline with windowing and bootstrapping on given start year 
#  with end year inferred from singal
bl.windowed.filtered = prepareBaseline(x.streamflow, year.start = 1961, 
                                       window.20 = TRUE)

}
