% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrtr-package.R
\docType{data}
\name{mc_modality}
\alias{mc_modality}
\title{McMaster Modality Data Set.}
\format{
A data frame with 4,146 rows and 37 variables:
\describe{
\item{id}{Unique identifier for respondents}
\item{choice}{Mode of transportation chosen: Active Travel (Cycle/Walk), HSR (local transit), Car, GO (regional transit)}
\item{LAT}{Latitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{LONG}{Longitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{shared_vehicle}{Indicator variable for having individual access to a private car (i.e., car shared with other household members): Yes/No}
\item{bicycle}{Indicator variable for owning a bicycle: Yes/No}
\item{gender}{Woman/Man}
\item{age}{Age in years}
\item{status}{Indicator variable for status at McMaster: Staff or Faculty/Student}
\item{care_giver}{Indicator variable for being primary care giver for any minors in the household: Yes/No}
\item{modality}{Indicator variable for number of available modes: One Mode/Two Modes/Three Modes/Four Modes}
\item{Boring}{Response to statement "Traveling is boring" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Buses_Comfortable}{Response to statement "The buses I usually travel in are comfortable" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Clean_Fuel}{Response to statement "To improve the environment, I am willing to pay a little more to use a hybrid, electric or other clean fuel vehicle" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Limit_Driving}{Response to statement "I limit my auto travel to help improve congestion and the environment" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Productive_Time}{Response to statement "I use my commute time productively" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Safe_Cycle}{Response to statement "I feel safe and secure to cycle around town" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Shops_Services}{Response to statement "Having shops and services within walking distance of my home is important to me" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Someone_Else}{Response to statement "Usually, I'd rather have someone else do the driving" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Stuck_Traffic}{Response to statement "Getting stuck in traffic doesn't bother me too much" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Transition}{Response to statement "My commute trip is a useful transition between home and school" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Travel_Alone}{Response to statement "I like traveling alone" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Travel_Tiring}{Response to statement "Traveling is generally tiring for me" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Wasted_Time}{Response to statement "Traveling is generally tiring for me" as factor: Strongly Disagree, Disagree, Neutral, Agree, Strongly Agree}
\item{Rate_Immigrant}{Proportion of inmigrants to total population in Dissemination Area}
\item{Rate_Non_Canadian}{Proportion of non-Canadian residents to total population in Dissemination Area}
\item{Rate_Labor}{Proportion of residents in Dissemination Area who are in the labor force}
\item{Rate_Unemployment}{Unemployment rate in Dissemination Area}
\item{Rate_Married}{Proportion of families headed by a married couple to total population in Dissemination Area}
\item{Mean_Age}{Mean age of residents in Dissemination Area in years}
\item{Mean_Children}{Mean number of children per family in Dissemination Area}
\item{Median_HH_Income}{Median family income in Dissemination Area in $10,000}
\item{LITA}{Transit access index – combination of capacity, frequency, and coverage of service (Wiley et al., 2011)}
\item{LUM}{Entropy-based land use mix index in Dissemination Area: lower values mean more homogenous land uses, higher values greater mix of uses}
\item{MAC_DISTANCE}{Network distance from place of residence to McMaster University in km}
\item{POPULATION_DENSITY}{Population density in Dissemination Area in people/sq.km}
\item{SF_P_RATIO}{Ratio of building footprint to parcel area in Dissemination Area: a measure of density of development}
}
}
\source{
Lavery, T., P\'{a}ez, A., & Kanaroglou, P.S. (2013). Driving out of choices: An investigation of transport modality in a university sample. Transportation Research Part A: Policy and Practice, 57:37-46 (https://doi.org/10.1016/j.tra.2013.09.010)
}
\usage{
data(mc_modality)
}
\description{
A dataset containing information about \emph{students}, \emph{staff}, and \emph{faculty} commuting to McMaster University.
Data were collected by means of a travel survey in the fall of 2010. Respondents were asked about their mode
of travel to McMaster University, in Hamilton, Canada. They were also asked about the modes available
to them. The data set also contains relevant attributes about the respondents. The format of the table is wide,
with each row representing an individual respondent. These variables were augmented with information from the
2011 Census of Canada and land use information from local sources.
}
\examples{
 data(mc_modality)
 summary(mc_modality)
}
\keyword{datasets}
