% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disposable.r
\name{make_packages}
\alias{make_packages}
\title{Create, install, load and attach multiple disposable packages}
\usage{
make_packages(..., lib_dir = tempfile(), imports = character(),
  quiet = TRUE)
}
\arguments{
\item{...}{Named expressions.
A separate package with the given name is created for each.}

\item{lib_dir}{Directory to install the package to.
Defaults to a temporary directory that is
deleted once the R session is over.}

\item{imports}{The 'Imports' field in the DESCRIPTION file,
the packages to import in each disposable package. It can be a
character vector, which applies to all packages, or a list of
character vectors, one for each package.}

\item{quiet}{Whether to show the installation process of
disposable packages.}
}
\value{
A named list with entries: \itemize{
    \item \code{lib_dir} The directory in which the packages are
      installed.
    \item \code{package} The named of the packages.
  }
}
\description{
If a package with the same name as a disposable one, is
loaded, then it will be unloaded. If a package with same name
as a disposable on is installed in \code{lib_dir}, then
it will be overwritten. (\code{lib_dir} is usually a temporary
directory, so this is not a big problem.)
}
\details{
Note that if you specify \code{lib_dir} and it points to an
existing directory, \code{make_package} overwrites the packages
there. If an error happens during installation or loading of
the disposables packages, then it will \emph{not} restore the
original contents of \code{lib_dir}, but it will remove
all newly installed disposable packages, even the ones
that were installed cleanly.
}
\section{Examples}{

\preformatted{
pkg <- make_packages(
  foo1 = { f <- function() print("hello!") ; d <- 1:10 },
  foo2 = { f <- function() print("hello again!") ; d <- 11:20 }
)
foo1::f()
foo2::f()
foo1::d
foo2::d
dispose_packages(pkg)
}
}

\seealso{
\code{\link{dispose_packages}}
}
