% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyline.R
\name{polyline.svg}
\alias{polyline.svg}
\title{Generate polyline SVG element}
\usage{
polyline.svg(points = NULL, fill, stroke, stroke.width, stroke.opacity,
  style.sheet = NULL)
}
\arguments{
\item{points}{a matrix, a series of coordinates}

\item{fill}{a character, color of the polyline, eg. "#000000"(default), "red"}

\item{stroke}{a characher, color of the polyline line, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the polyline line, default: 1}

\item{stroke.opacity}{a number, stroke opacity of the polyline line, default:1. If the stroke opacity is 0, the polygon line is invisible}

\item{style.sheet}{a vector or a chatacter, other style of the polyline, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function can generate a polyline form SVG element
The <polyline> SVG element is an SVG basic shape that creates straight
lines connecting several points. Typically a polyline is used to create
open shapes as the last point doesn't have to be connected to the first
point. For closed shapes see the <polygon> element.
}
\examples{
points <- matrix(c(1,2,3, 11,12,13), nrow = 3, ncol = 2)
polyline.svg(points = points)
polyline.svg(points = points, stroke = "yellow")


}
