% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_source.R
\name{attach_source}
\alias{attach_source}
\title{Source R files into an attached environment}
\usage{
attach_source(
  ...,
  name = as_tidy_env_name(c(...), prefix = "source:"),
  recursive = FALSE,
  pos = 2L,
  chdir = FALSE,
  warn.conflicts = TRUE,
  mask.ok = NULL,
  parent = .GlobalEnv
)
}
\arguments{
\item{...}{filepaths to R files, or paths to directories containing R files.}

\item{name}{A string, the name for the attached environment. By default, the
name is constructed from paths supplied to \code{...}. If the requested name is
not on the search path, a new environment of this name is attached.}

\item{recursive}{If directories are passed to \code{...}, whether to search them
recursively.}

\item{pos}{The position where to attach the environment, if creating a new
one. If an environment of \code{name} already exists, \code{pos} is ignored.}

\item{chdir}{logical. if TRUE, the \R working directory is temporarily
changed to the directory containing the file(s) being sourced.}

\item{warn.conflicts}{logical. If TRUE (the default), print warnings about
objects in the attached environment that that are masking or masked by
other objects of the same name. If the environment specified by \code{name} is
was attached previously, then only newly defined objects are warned about.
N.B., Even though the name is \code{warn.conflicts}, the messages about
conflicts are not \code{warning()}s but \code{packageStartupMessage()}s, and can be
suppressed with \code{suppressPackageStartupMessages()}}

\item{mask.ok}{character vector of names of objects that can mask objects on
the search path without signaling a warning if \code{warn.conflicts} is \code{TRUE}.
The sourced R script can also define \code{.mask.OK} in the R environment, which
has the same effect as passing it as an argument.}

\item{parent}{R environment. If an environment specified by \code{name} is not
already attached, then the supplied R scripts are first sourced into a new
environment with the supplied parent. The default of \code{globalenv()} enables
calling \code{library()} in the scripts and having the subsequent
code in the scripts "see" the attached packages.}
}
\value{
The attached environment, invisibly.
}
\description{
Source R files into an attached environment
}
\seealso{
\link{import_from}, \link{set_library_default_pos}
}
