% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines.R
\name{use_epoxy_knitr_engines}
\alias{use_epoxy_knitr_engines}
\alias{use_epoxy_glue_engine}
\title{Use the epoxy knitr engines}
\usage{
use_epoxy_knitr_engines(
  use_glue_engine = "glue" \%in\% include,
  include = c("md", "html", "latex", "mustache")
)

use_epoxy_glue_engine()
}
\arguments{
\item{use_glue_engine}{If \code{TRUE} (default \code{FALSE}), uses \pkg{epoxy}'s \code{glue}
engine, most likely overwriting the \code{glue} engine provided by \pkg{glue}.}

\item{include}{The epoxy knitr engines to include. Defaults to all engines
except for the \code{glue} engine (which is just an alias for the \code{epoxy}
engine).}
}
\value{
Silently sets \pkg{epoxy}'s knitr engines and invisible returns
\link[knitr:knit_engines]{knitr::knit_engines} as they were prior to the function call.
}
\description{
Sets \pkg{epoxy}'s \pkg{knitr} engines for use by \pkg{knitr} in R Markdown
and other document formats powered by \pkg{knitr}. These engines are also
set up when loading \pkg{epoxy} with \code{library()}, so in general you will not
need to call this function explicitly.

\pkg{epoxy} provides four \pkg{knitr} engines:
\itemize{
\item \code{epoxy} uses default \pkg{glue} syntax, e.g. \code{{var}} for markdown outputs
\item \code{epoxy_html} uses double brace syntax, e.g. \code{{{var}}} for HTML outputs
\item \code{epoxy_latex} uses double angle brackets syntax, e.g. \verb{<<var>>} for LaTeX
outputs
\item \code{whisker} uses the \pkg{whisker} package which provides an R-based
implementation of the \href{https://mustache.github.io/}{mustache} templating
language.
}

For historical reasons, aliases for the HTML and LaTeX engines are also
created: \code{glue_html} and \code{glue_latex}. You may opt into a third alias —
\code{glue} for the \code{epoxy} engine — by calling \code{use_epoxy_glue_engine()}, but
note that this will most likely overwrite the \code{glue} engine provided by the
\pkg{glue} package.
}
\section{Functions}{
\itemize{
\item \code{use_epoxy_glue_engine()}: Use \pkg{epoxy}'s \code{epoxy} engine as
the \code{glue} engine.

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
use_epoxy_knitr_engines()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=epoxy]{epoxy()}}, \code{\link[=epoxy_html]{epoxy_html()}}, \code{\link[=epoxy_latex]{epoxy_latex()}}, and \code{\link[=epoxy_mustache]{epoxy_mustache()}}
for the functions that power these knitr engines.
}
