% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epoxy.R
\name{epoxy}
\alias{epoxy}
\alias{epoxy_html}
\alias{epoxy_latex}
\title{Epoxy string interpolation}
\usage{
epoxy(
  ...,
  .data = NULL,
  .sep = "",
  .envir = parent.frame(),
  .open = "{",
  .close = "}",
  .na = "",
  .null = "",
  .comment = character(),
  .literal = FALSE,
  .trim = FALSE,
  .transformer = NULL,
  .collapse = NULL,
  .style = lifecycle::deprecated()
)

epoxy_html(
  ...,
  .data = NULL,
  .sep = "",
  .envir = parent.frame(),
  .open = "{{",
  .close = "}}",
  .na = "",
  .null = "",
  .comment = "",
  .literal = FALSE,
  .trim = FALSE,
  .transformer = NULL,
  .collapse = NULL
)

epoxy_latex(
  ...,
  .data = NULL,
  .sep = "",
  .envir = parent.frame(),
  .open = "<<",
  .close = ">>",
  .na = "",
  .null = "",
  .comment = "",
  .literal = FALSE,
  .trim = FALSE,
  .transformer = NULL,
  .collapse = NULL
)
}
\arguments{
\item{...}{[\code{expressions}]\cr Unnamed arguments are taken to be expression
string(s) to format. Multiple inputs are concatenated together before formatting.
Named arguments are taken to be temporary variables available for substitution.}

\item{.data}{A data set}

\item{.sep}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed, it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}

\item{.open}{[\code{character(1)}: \sQuote{\\\{}]\cr The opening delimiter around
the template variable or expression. Doubling the full delimiter escapes
it.}

\item{.close}{[\code{character(1)}: \sQuote{\\\}}]\cr The closing delimiter
around the template variable or expression. Doubling the full delimiter
escapes it.}

\item{.na}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace \code{NA} values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}

\item{.null}{[\code{character(1)}: \sQuote{character()}]\cr Value to replace
NULL values with. If \code{character()} whole output is \code{character()}. If
\code{NULL} all NULL values are dropped (as in \code{paste0()}). Otherwise the
value is replaced by the value of \code{.null}.}

\item{.comment}{[\code{character(1)}: \sQuote{#}]\cr Value to use as the comment
character.}

\item{.literal}{[\code{boolean(1)}: \sQuote{FALSE}]\cr Whether to treat single or
double quotes, backticks, and comments as regular characters (vs. as
syntactic elements), when parsing the expression string. Setting \code{.literal = TRUE} probably only makes sense in combination with a custom
\code{.transformer}, as is the case with \code{glue_col()}. Regard this argument
(especially, its name) as experimental.}

\item{.trim}{[\code{logical(1)}: \sQuote{TRUE}]\cr Whether to trim the input
template with \code{\link[glue:trim]{trim()}} or not.}

\item{.transformer}{A transformer function or transformer chain created with
\code{\link[=epoxy_transform]{epoxy_transform()}}. Alternatively, a character vector of epoxy transformer
names, e.g. \code{c("bold", "collapse")} or a list of epoxy transformers, e.g.
\code{list(epoxy_transform_bold(), epoxy_transform_collapse())}.

In \pkg{epoxy}, you'll most likely want to use the defaults or consult
\code{\link[=epoxy_transform]{epoxy_transform()}} for more information. See also \code{\link[glue:glue]{glue::glue()}} for more
information on transformers.}

\item{.collapse}{A character string used to collapse a vector result into a
single value. If \code{NULL} (the default), the result is not collapsed.}

\item{.style}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{.transformer}
instead.}
}
\value{
Returns a transformed string, using \code{glue::glue()} but with the
additional transformers provided to the \code{.transformer} argument of
\code{epoxy()}.
}
\description{
These functions power the knitr chunk engines and are wrappers around
\code{\link[glue:glue]{glue::glue()}}, with a few extra conveniences provided by \pkg{epoxy}.
\itemize{
\item \code{epoxy()} is super \code{glue::glue()}.
\item \code{epoxy_html()} is super \code{glue::glue()} with HTML-specific defaults.
\item \code{epoxy_latex()} is super \code{glue::glue()} with LaTeX-specific defaults.
}

Each of these functions can be called directly or used as a knitr chunk
engine where the chunk text is handled as if it were a string passed into the
function version. When used as a knitr chunk engine, the function arguments
can be passed in as chunk options.

All of \code{epoxy()}, \code{epoxy_html()} and \code{epoxy_latex()} use
\code{\link[=epoxy_transform_inline]{epoxy_transform_inline()}} by default. This transformer brings a concise
inline-formatting syntax that you can read more about in
\code{?epoxy_transform_inline}.

\code{epoxy_html()} also includes an inline transformation syntax that makes it
easier to wrap the expression text in HTML elements with a specific ID or
a set of classes. Learn more about this syntax in \code{?epoxy_transform_html}.
}
\examples{
movie <- bechdel[1, ]
movies <- bechdel[2:4, ]

# A basic example with a single row of data
epoxy("{.emph movie$title} ({movie$year}) was directed by {movie$director}.")

# Or vectorized over multiple rows of data
epoxy("* {.emph movies$title} ({movies$year}) was directed by {movies$director}.")

# You can provide the data frame to `.data` to avoid repeating `data$`
epoxy("{.emph title} ({year}) was directed by {director}.", .data = movie)
epoxy("* {.emph title} ({year}) was directed by {director}.", .data = movies)

# Inline transformers can be nested
epoxy("I'd be happy to watch {.or {.italic title}}.", .data = movies)
epoxy("They were directed by {.and {.bold director}}.", .data = movies)

# Learn more about inline transformers in ?epoxy_transform_inline
epoxy("The budget for {.emph title} was {.dollar budget}.", .data = movie)

# --------- HTML and LaTeX variants ---------
# There are also HTML and LaTeX variants of epoxy.
# Each uses default options that are most natural for the format.

# epoxy_html() uses `{{ expr }}` for delimiters
epoxy_html("I'd be happy to watch {{ title }}.", .data = movie)
# It also supports an HTML transformer syntax
epoxy_html("I'd be happy to watch {{em.movie-title title}}.", .data = movie)
# Or use the inline transformer syntax, which uses `@` instead of `.` in HTML
epoxy_html("I'd be happy to watch {{@or {{@emph title}} }}.", .data = movies)

# epoxy_latex() uses `<< expr >>` for delimiters
epoxy_latex("I'd be happy to watch <<.or <<.emph title >> >>.", .data = movies)
}
\seealso{
\itemize{
\item \code{\link[=use_epoxy_knitr_engines]{use_epoxy_knitr_engines()}} for knitr engines powered by these epoxy
functions.
\item \code{\link[=epoxy_mustache]{epoxy_mustache()}} for more powerful templating needs when you don't
need epoxy's inline formatting syntax.
}
}
