% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabnew.r
\name{stab.fw}
\alias{stab.fw}
\title{F-W Regression Based Yield Stability Analysis}
\usage{
stab.fw(y, Gen, Env, times, Rep, X = NULL, alpha = NULL)
}
\arguments{
\item{y}{A vector of yield data}

\item{Gen}{A vector of Genotypes}

\item{Env}{A vector of Environments}

\item{times}{Replication number for resampling}

\item{Rep}{Replication included or not included}

\item{X}{Independent variables matrix or vector}

\item{alpha}{Preset alpha value}
}
\value{
A list of yield stability results
}
\description{
F-W Regression Based Yield Stability Analysis
}
\examples{
require(genstab)
data(maize)
#names(maize)
Geno=as.vector(maize$Cultivar)
Env=paste(maize$Location,maize$Year,sep=":")
y=maize$Yld
res=stab.fw(y,Gen=Geno,Env=Env,times=10,Rep=TRUE)
res
##end
}
\references{
Finlay, K.W., G.N. Wilkinson 1963. The analysis of adaptation in a plant breeding programme. Australian Journal of Agricultural Research 14: 742-754.

Wu, J., K. Glover, W. Berzonsky, 2012. Statistical tests for stability analysis with resampling techniques. 25th Conference of Applied Statistics in Agriculture. p88-108. April 29-May 01, 2012. Manhattan, KS

Wu, J., K. Glover, and N. Mueller 2014. Check based stability analysis method and its application to winter wheat variety trials," Conference on Applied Statistics in Agriculture. https://doi.org/10.4148/2475-7772.1006
}
