#' Order statistics
#'
#' Sample a subset of order statistics of the Uniform(0,1) distribution
#'
#' @param n Total number of independent draws
#' @param orderstats Which order statistics to generate, in increasing order
#' @details Uniform order statistics are generated by the exponential spacings method (see Ripley for example).
#' @return A vector of order statistics equal in length to \code{orderstats}
#' @references Brian Ripley `Stochastic Simulation' Wiley (1987)
#' @examples
#' orderstats(100, c(25,50,75))
#' @export
orderstats = function(n, orderstats) {
  p = length(orderstats)
  kk = c(0,orderstats,n+1)
  w = stats::rgamma(p+1, kk[-1] - kk[1:(p+1)])
  cumsum(w[1:p]) / sum(w)
}
