% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables_builtin.R
\name{gtm_builtin_create}
\alias{gtm_builtin_create}
\title{Enable a built-in variable}
\usage{
gtm_builtin_create(account_id, container_id, workspace_id, variable)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{variable}{A Builtin Variable or list of built in variables. Valid values are here \code{\link{variables_list}}}
}
\description{
This enables one of the built-in variables in GTM.  It is the inverse of \code{\link{gtm_builtin_delete}}
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
variable <- 'clickId'

builtinVaribles<- gtm_builtin_create(accountId, containerId, workspaceId, variable)

listOfVaribales <- c('clickClasses', 'clickElement')

newEnabledVars <- gtm_builtin_create(accountId, containerId, workspaceId, listOfVaribales)

}


}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/built_in_variables/create}

Other built in variable functions: 
\code{\link{gtm_builtin_delete}()},
\code{\link{gtm_builtin_list}()},
\code{\link{gtm_builtin_revert}()},
\code{\link{variables_list}}
}
\concept{built in variable functions}
