% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmsem.biher.R
\name{grmsem.biher}
\alias{grmsem.biher}
\title{grmsem bivariate heritability estimation function.}
\usage{
grmsem.biher(ph, grmsem.var.out = NULL)
}
\arguments{
\item{ph}{Phenotype file as R dataframe (columns: >=2 phenotypes, rows: ni individuals in the same order as G). No default.}

\item{grmsem.var.out}{A grmsem.var object with unstandardised parameters (factor loadings). Default NULL.}
}
\value{
\code{grmsem.biher} returns a list object consisting of the following matrices:
\item{VPO}{observed phenotypic variance/covariance matrix}
\item{VA}{estimated genetic variance}
\item{BIHER}{estimated bivariate heritability (off-diagonals): VA / VPO}
\item{BIHER.se}{standard error of estimated bivariate heritability}
\item{BIHER.Z}{Z (wald) of estimated bivariate heritability}
\item{BIHER.p}{p (Wald) of estimated bivariate heritability}
}
\description{
This function estimates the bivariate heritability.
}
\details{
The \code{grmsem.biher} function estimates the bivariate heritability 
(DS, Cholesky, IP and IPC models) from the observed phenotype data and a \code{grmsem.var} object. 
All standard errors are derived with the Delta method.
}
\examples{
#(runtime should be less than one minute)
\donttest{
out <- grmsem.fit(ph.small, G.small, LogL = TRUE, estSE = TRUE)
var.out <- grmsem.var(out)
grmsem.biher(ph.small, var.out)}
}
\keyword{grmsem}
