% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hds_lc_hat.R
\name{hdslcse.fast}
\alias{hdslcse.fast}
\title{Hazard discrimination summary (local constant) standard error estimate}
\usage{
hdslcse.fast(S, betahat, m, betahatse)
}
\arguments{
\item{S}{A vector of length \code{nrow(m)} (which is typically the number of
observations n), where each value is the subject-specific survival at time t
where t is implied by the choice of \code{betahat}.}

\item{betahat}{A p x 1 vector of coefficient estimates at time t of interest
from the local-in-time Cox model. Vector length p is the number of
covariates. Typically the output from \code{hdslc::finda} is passed here.}

\item{m}{A numeric n x p matrix of covariate values, with a column for each
covariate and each observation is on a separate row.}

\item{betahatse}{A p x p covariance matrix for betahat at time t}
}
\value{
Variance estimate that has not been normalized. To get a usable
  standard error estimate, divide the output of this function by the
  bandwidth and sample size, and then take the square root.
}
\description{
\code{hdslcse.fast} calculates an estimate of the variance for the
local constant hazard discrimination summary estimator at a time t. The time
t is implied by \code{S}, \code{betahat}, and \code{betahatse}
}
\details{
The use will typically not interact with this function directly. Instead this
function is wrapped by \code{hdslc}.
}

