% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{data_to_boxplot}
\alias{data_to_boxplot}
\title{Helper to transform data frame for boxplot highcharts format}
\usage{
data_to_boxplot(
  data,
  variable,
  group_var = NULL,
  group_var2 = NULL,
  add_outliers = FALSE,
  ...
)
}
\arguments{
\item{data}{The data frame containing variables.}

\item{variable}{The variable to calculate the box plot data.}

\item{group_var}{A variable to split calculation}

\item{group_var2}{A second variable to create separate series.}

\item{add_outliers}{A logical value indicating if outliers series should
be calculated. Default to \code{FALSE}.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highcharts/plotOptions.series}.}
}
\description{
Helper to transform data frame for boxplot highcharts format
}
\examples{

data(pokemon)

dat <- data_to_boxplot(pokemon, height)

highchart() \%>\%
  hc_xAxis(type = "category") \%>\%
  hc_add_series_list(dat)

dat <- data_to_boxplot(pokemon, height, type_1, name = "height in meters")

highchart() \%>\%
  hc_xAxis(type = "category") \%>\%
  hc_add_series_list(dat)
\dontrun{

}

}
