% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icecream-package.R
\docType{package}
\name{icecream-package}
\alias{icecream}
\alias{icecream-package}
\title{Icecream: Never use \code{print()} to debug again}
\description{
Icecream provides a more user-friendly print debugging experience. Use \code{\link[=ic]{ic()}} wherever you would
use \code{print()} and see the expression and its value easily.
}
\section{Options}{

The following options can be used to control behaviour:
\itemize{
\item \code{icecream.enabled}: Boolean. If \code{FALSE}, calls to \code{ic(foo)} simply evaluate and return \code{foo}.
No output is printed.
\item \code{icecream.prefix}: This is printed at the beginning of every line. Defaults to \code{"ic|"}.
\item \code{icecream.include.context}: Boolean. If \code{TRUE}, when calling \code{ic(foo)} the source file:line
or environment will be printed along with the expression and value. This can be useful for more
complicated debugging but produces a lot of output so is disabled by default. When \code{ic()} is
called with no arguments, the context is always printed because showing the location of the
call is the only reason to call \code{ic()} on its own.
\item \code{icecream.peeking.function}: indicates the function that summarizes the object. Default value
is \code{ic_autopeek}, which works like \code{utils::str} for most of the time, but gives more
informative output for \code{lists}, \code{data.frames} and their subclasses in a more compact way.
\item \code{icecream.max.lines} Integer. Determines maximum number of lines that the peek of an object
occupies; defaults to 1.
\item \code{icecream.output.function}: Not implemented yet. See the
\href{https://github.com/gruns/icecream#configuration}{configuration} section of the original
project docs for details of what it will do.
\item \code{icecream.arg.to.string.function}: Not implemented yet. See the
\href{https://github.com/gruns/icecream#configuration}{configuration} section of the original
project docs for details of what it will do.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://www.lewinfox.com/icecream/}
  \item \url{https://github.com/lewinfox/icecream}
  \item \url{http://www.lewinfox.com/icecream/}
  \item Report bugs at \url{https://github.com/lewinfox/icecream/issues}
}

}
\author{
\strong{Maintainer}: Lewin Appleton-Fox \email{lewin.a.f@gmail.com}

Authors:
\itemize{
  \item Dominik Rafacz \email{dominikrafacz@gmail.com} (\href{https://orcid.org/0000-0003-0925-1909}{ORCID})
}

Other contributors:
\itemize{
  \item Ben Stiles [contributor]
}

}
\keyword{internal}
