#' Sample Size Planning Based on Intrinsic Kappa Value
#'
#' Providing functions for the computation of the intrinsic kappa value.
#'
#' @references
#' R. Sanchez-Marquez, F. Gerhorst and D. Schindler (2023) "Effectiveness of quality
#' inspections of attributive characteristics – A novel and practical method for estimating
#' the “intrinsic” value of kappa based on alpha and beta statistics." \emph{Computers & Industrial Engineering}, 109006.
#'
#'
#' @seealso
#' For the computation of the intrinsic kappa value, see \code{\link{intrinsicKappa}}.
#'
#' @docType package
#' @name intrinsicKappa-package
#' @author David Schindler \email{dv.schindler@@gmail.com}, Rafael Sanchez-Marquez, Frank Gerhorst
#'
#' @importFrom stats qf
#' @importFrom utils capture.output
#'
NULL
