% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability.R
\name{wle}
\alias{wle}
\title{Bias-corrected (Warm's) estimates of ability}
\usage{
wle(resp, ip)
}
\arguments{
\item{resp}{A matrix of responses: persons as rows, items as columns,
entries are either 0 or 1, no missing data}

\item{ip}{Item parameters: the object returned by \eqn{est}.}
}
\value{
A matrix with the ability estimates in column 1, and their standard
errors of measurement (SEM) in column 2, and the number of non-missing
reponses in column 3
}
\description{
Weighted likelihood estimates (WLE) of ability, designed to remove the first
order bias term from the ML estimates. WLE are finite for response patterns
consisting of either uniformly wrong or uniformly correct responses.
}
\examples{

th.bce <- wle(resp=Scored, ip=Scored2pl)

}
\references{
Warm T.A. (1989) Weighted Likelihood Estimation of Ability in
Item Response Theory. Psychometrika, 54, 427-450.
}
\seealso{
\code{\link{mlebme}}, \code{\link{eap}}
}
\author{
Ivailo Partchev
}
\keyword{models}
