% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracelines.R
\name{tsc}
\alias{tsc}
\title{True scores with standard errors}
\usage{
tsc(ip, theta)
}
\arguments{
\item{ip}{Item parameters: the output of \code{est}, or a 3-column matrix 
corresponding to its first element, \code{est}.}

\item{theta}{An object containing ability estimates, as output by function
\code{mlebme} or \code{eap}}
}
\value{
A matrix with the true scores in column 1, and their standard errors
of measurement (SEM) in column 2
}
\description{
Computes the IRT true scores (test response function at the estimated
ability) and an estimate of their standard error via the delta theorem,
treating item parameters as known).
}
\examples{

th <- mlebme(resp=Scored, ip=Scored2pl)
tsc(Scored2pl, th)

}
\seealso{
\code{\link{mlebme}}, \code{\link{eap}}, \code{\link{trf}}
}
\author{
Ivailo Partchev
}
\keyword{models}
