% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{likweibull}
\alias{likweibull}
\title{Weibull Log Likelihood Function}
\usage{
likweibull(x, shape, scale = 1, log = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{shape}{shape and scale parameters, the latter defaulting to 1.}

\item{scale}{shape and scale parameters, the latter defaulting to 1.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the Weibull density given
the data where shape and scale can be held constant or if vector were given
vector will be returned.
}
\description{
The log likelihood of a Weibull density with data, x, shape and scale
parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likweibull(x = rweibull(n = 2, shape = 3),
        shape = 3)
}
