% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_as_dim}
\alias{bind_as_dim}
\alias{bind_as_rows}
\alias{bind_as_cols}
\alias{bind_on_dim}
\alias{bind_on_rows}
\alias{bind_on_cols}
\title{Bind arrays along a specified dimension}
\usage{
bind_as_dim(list_of_arrays, which_dim)

bind_as_rows(...)

bind_as_cols(...)

bind_on_dim(list_of_arrays, which_dim)

bind_on_rows(...)

bind_on_cols(...)
}
\arguments{
\item{list_of_arrays}{a list of arrays. All arrays must be of the same
dimension. NULL's in place of arrays are automatically dropped.}

\item{which_dim}{Scalar integer specifying the index position of where to
introduce the new dimension to introduce. Negative numbers count from the
back. For example, given a 3 dimensional array, \code{-1}, is equivalent to \code{3},
\code{-2} to \code{2} and \code{-3} to \code{1}.}

\item{...}{Arrays to be bound, specified individually or supplied as a single
list}
}
\value{
An array, with one additional dimension.
}
\description{
\verb{bind_as_*} introduces a new dimension, such that each element in
\code{list_of_arrays} corresponds to one index position along the new dimension in
the returned array. \verb{bind_on_*} binds all elements along an existing
dimension, (meaning, the returned array has the same number of dimensions as
each of the arrays in the list).
}
\details{
\verb{bind_*_rows()} is a wrapper for the common case of \verb{bind_*_dim(X, 1)}.
\verb{bind_*_cols()} is a wrapper for the common case of \verb{bind_*_dim(X, -1)}.
}
\examples{
list_of_arrays <- replicate(10, array(1:8, dim = c(2,3,4)), FALSE)

dim(list_of_arrays[[1]])

# bind on a new dimension
combined_as <- bind_as_rows(list_of_arrays)
dim(combined_as)
dim(combined_as)[1] == length(list_of_arrays)

# each element in `list_of_arrays` corresponds to one "row"
# (i.e., one entry in along the first dimension)
for(i in seq_along(list_of_arrays))
  stopifnot(identical(combined_as[i,,,], list_of_arrays[[i]]))

# bind on an existing dimension
combined_on <- bind_on_rows(list_of_arrays)
dim(combined_on)
dim(combined_on)[1] == sum(sapply(list_of_arrays, function(x) dim(x)[1]))
identical(list_of_arrays[[1]], combined_on[1:2,,])
for (i in seq_along(list_of_arrays))
  stopifnot(identical(
    list_of_arrays[[i]], combined_on[ (1:2) + (i-1)*2,,]
  ))

# bind on any dimension
combined <- bind_as_dim(list_of_arrays, 3)
dim(combined)
for(i in seq_along(list_of_arrays))
   stopifnot(identical(combined[,,i,], list_of_arrays[[i]]))
}
