% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooling-basic-funs.R
\name{minipool}
\alias{minipool}
\title{Number of Assays Needed using Mini-Pooling}
\usage{
minipool(v, K = 5, vf_cut = 1000, lod = 0, msg = T)
}
\arguments{
\item{v}{A vector of non-negative numerical assay results.}

\item{K}{Pool size; default is \code{K = 5}.}

\item{vf_cut}{Cutoff value for defining positive cases;
default is \code{vf_cut = 1000}.}

\item{lod}{A vector of lower limits of detection or a scalar if the limits are the
same; default is \code{lod = 0}.}

\item{msg}{Message generated during calculation; default is \code{TRUE}.}
}
\value{
A vectorof length \code{N\%/\%K} for the numbers of assays needed for all pools
that are formed.
}
\description{
Function \code{minipool(...)} calculates the number of assays required, when
using mini-pooling, for
pools that are formed following the order that individual samples appear in the data.
}
\details{
Suppose that N samples are collected for pooled testing. The first
\code{K} samples are combined to
form a pool, the next \code{K} samples are combined to form the second
pool, and so on. If the number of samples for the last pool is less than
\code{K}, these remaining samples are not used to form a pool (i.e.
not included in the calculation). Therefore, a total of
\code{N\%/\%K} pools are formed. The function calculates the number of
assays needed for each of these pools. For mini-pooling, if a pool is
negative, no further tests are needed and all samples in the pool
are concluded as being negative; so the total number of
assays required is one. Otherwise if the pool is tested positive, all
individual samples in the pool are tested and the total number of assays
required is \code{(K + 1)}.
}
\examples{
K=5; n = 50;
n.pool  = n/K; n.pool
#  [1] 10
set.seed(100)
pvl = rgamma(n, shape = 2.8, scale = 150)
minipool(pvl)
#  A total of 10 pools are formed.
#  The numbers of assays required by these pools are:
#  [1] 6 6 6 6 6 6 6 6 6 6

}
\references{
Dorfman R. The detection of defective members of large populations. The
Annals of Mathematical Statistics. 1943;14(4):436-440.

Liu T, Hogan JW, Daniels, MJ, Coetzer M, Xu Y, Bove G, et al. Improved HIV-1 Viral Load
Monitoring Capacity Using Pooled Testing with Marker-Assisted Deconvolution. Journal of
AIDS. 2017;75(5): 580-587.
}
\seealso{
\link{mpa}, \link{mmpa}, \link{pooling_mc}
}
\keyword{mini-pooling.}
