% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fnames.R, R/freqlist.R,
%   R/tokenize.R, R/types.R
\name{keep_pos}
\alias{keep_pos}
\alias{drop_pos.fnames}
\alias{keep_pos.fnames}
\alias{drop_pos.freqlist}
\alias{keep_pos.freqlist}
\alias{drop_pos}
\alias{drop_pos.tokens}
\alias{keep_pos.tokens}
\alias{drop_pos.types}
\alias{keep_pos.types}
\title{Subset an object by index}
\usage{
keep_pos(x, pos, invert = FALSE, ...)

\method{drop_pos}{fnames}(x, pos, ...)

\method{keep_pos}{fnames}(x, pos, invert = FALSE, ...)

\method{drop_pos}{freqlist}(x, pos, ...)

\method{keep_pos}{freqlist}(x, pos, invert = FALSE, ...)

drop_pos(x, pos, ...)

\method{drop_pos}{tokens}(x, pos, ...)

\method{keep_pos}{tokens}(x, pos, invert = FALSE, ...)

\method{drop_pos}{types}(x, pos, ...)

\method{keep_pos}{types}(x, pos, invert = FALSE, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{pos}{A numeric vector, the numbers in which identify positions (= indices)
of items in \code{x}.

If the numbers are positive, then their values point
to the items that are to be selected.

If the numbers are negative,
then their absolute values point to the items that are not to be selected.
Positive and negative numbers must not be mixed.}

\item{invert}{Logical. Whether the matches should be selected rather than the
non-matches.}

\item{...}{Additional arguments.}
}
\value{
Object of the same class as \code{x} with the selected elements only.
}
\description{
These methods can be used to subset objects based on a numeric vector of indices.
}
\details{
The methods \code{\link[=keep_pos]{keep_pos()}} and \code{\link[=drop_pos]{drop_pos()}} are part of a family of methods of
the mclm package used to subset different objects. The methods
starting with \code{keep_} extract the items in \code{x} based on the criterion specified
by the second argument. In contrast, the methods starting with \code{drop_} \emph{exclude}
the items that match the criterion in the same argument.

Calling a \code{drop_} method is equivalent to calling its \code{keep_} counterpart when
the \code{invert} argument is \code{TRUE}.
}
\examples{
# For a 'freqlist' object --------------------
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

keep_pos(flist, c(2, 3))

# For a 'types' object -----------------------
(tps <- as_types(letters[1:10]))

keep_pos(tps, c(1, 3, 5, 7, 9))
drop_pos(tps, c(1, 3, 5, 7, 9))

# For a 'tokens' object ----------------------
(tks <- as_tokens(letters[1:10]))

keep_pos(tks, c(1, 3, 5, 7, 9))
drop_pos(tks, c(1, 3, 5, 7, 9))
}
\seealso{
Other subsetters: 
\code{\link{brackets}},
\code{\link{keep_bool}()},
\code{\link{keep_re}()},
\code{\link{keep_types}()}
}
\concept{subsetters}
