% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc.R
\name{print_kwic}
\alias{print_kwic}
\title{Print a concordance in KWIC format}
\usage{
print_kwic(
  x,
  min_c_left = NA,
  max_c_left = NA,
  min_c_match = NA,
  max_c_match = NA,
  min_c_right = NA,
  max_c_right = NA,
  from = 1,
  n = 30,
  drop_tags = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\link{conc}}.}

\item{min_c_left, max_c_left}{Minimum and maximum size, expressed in number of
characters, of the left co-text in the KWIC display.}

\item{min_c_match, max_c_match}{Minimum and maximum size, expressed in number of
characters, of the match in the KWIC display.}

\item{min_c_right, max_c_right}{Minimum and maximum size, expressed in number of
characters, of the right co-text in the KWIC display.}

\item{from}{Index of the first item of \code{x} to be displayed.}

\item{n}{Number of consecutive items in \code{x} to be displayed.}

\item{drop_tags}{Logical. Should tags be hidden?}
}
\value{
Invisibly, \code{x}.
}
\description{
This function prints a concordance in KWIC format.
}
\seealso{
\link[=print.conc]{print}
}
