% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{read_freqlist}
\alias{read_freqlist}
\title{Read a frequency list from a csv file}
\usage{
read_freqlist(file, sep = "\\t", file_encoding = "UTF-8", ...)
}
\arguments{
\item{file}{Character vector of length 1. Path to the input file.}

\item{sep}{Character vector of length 1. Column separator.}

\item{file_encoding}{File encoding used in the input file.}

\item{...}{Additional arguments (not implemented).}
}
\value{
Object of class \code{\link{freqlist}}.
}
\description{
This function reads an object of the class \code{\link{freqlist}} from a csv file. The csv
file is assumed to contain two columns, the first being the type and the
second being the frequency of that type. The file is also assumed to
have a header line with the names of both columns.
}
\details{
\code{read_freqlist} not only reads the file \code{file},
but also checks whether a configuration file exists with a name that
is identical to \code{file}, except that it has the filename extension
\code{".yaml"}.

If such a file exists, then that configuration file
is taken to 'belong' to \code{file} and is also read and the frequency list attributes
\code{"tot_n_tokens"} and \code{"tot_n_types"} are retrieved from it.

If no such configuration file exists,
then the values for \code{"tot_n_tokens"} and \code{"tot_n_types"} are
calculated on the basis of the frequencies in the frequency list.
}
\examples{
toy_corpus <- "Once upon a time there was a tiny toy corpus.
It consisted of three sentences. And it lived happily ever after."
freqs <- freqlist(toy_corpus, as_text = TRUE)

print(freqs, n = 1000)
\dontshow{.old_wd <- setwd(tempdir())}
write_freqlist(freqs, "example_freqlist.csv")
freqs2 <- read_freqlist("example_freqlist.csv")
print(freqs2, n = 1000)
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=write_freqlist]{write_freqlist()}}

Other reading functions: 
\code{\link{read_assoc}()},
\code{\link{read_conc}()},
\code{\link{read_fnames}()},
\code{\link{read_tokens}()},
\code{\link{read_txt}()},
\code{\link{read_types}()}
}
\concept{reading functions}
