% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{read_types}
\alias{read_types}
\title{Read a vector of types from a text file}
\usage{
read_types(
  file,
  sep = NA,
  file_encoding = "UTF-8",
  trim_types = FALSE,
  remove_duplicates = FALSE,
  sort = FALSE,
  ...
)
}
\arguments{
\item{file}{Name of the input file.}

\item{sep}{If not \code{is.na(sep)}, then \code{sep} must be a character vector
of length one. In that case, \code{sep} is interpreted as a
type separator in the input file. This separator the serves as an
additional type separator, next to the end of each line.
The end of a line always indicated a separator between types (in other
words, types cannot cross lines).}

\item{file_encoding}{The file encoding used in the input file.}

\item{trim_types}{Logical. Should leading and trailing
white space should be stripped from the types.}

\item{remove_duplicates}{Logical. Should duplicates be removed from \code{x}
prior to coercing to a vector of types.}

\item{sort}{Logical. Should \code{x} be
alphabetically sorted prior to coercing to a vector of types;
this argument is ignored if \code{remove_duplicates} is \code{TRUE},
because the result of removing duplicates is always sorted.}

\item{...}{Additional arguments (not implemented).}
}
\value{
Object of class \code{\link{types}}.
}
\description{
This function read an object of the class \code{\link{types}} from a text file. By default,
the text file is assumed to contain one type on each line.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
types <- as_types(c("first", "second", "third"))
write_types(types, "file_with_types.txt")
types_2 <- read_types("file_with_types.txt")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=write_types]{write_types()}}

Other reading functions: 
\code{\link{read_assoc}()},
\code{\link{read_conc}()},
\code{\link{read_fnames}()},
\code{\link{read_freqlist}()},
\code{\link{read_tokens}()},
\code{\link{read_txt}()}
}
\concept{reading functions}
