% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CALORIES.R
\docType{data}
\name{Calorie_Counts}
\alias{Calorie_Counts}
\alias{E_CALORIES_INITIAL}
\alias{E_CALORIES_FINAL}
\alias{P_CALORIES}
\alias{THETA_CALORIES}
\alias{ID_CALORIES}
\title{Data: Calorie Counts}
\format{
\describe{
\item{\code{E_CALORIES_INITIAL}}{is a list of the judges' initial estimates of the calorie counts in each of the 36 meals.
Specifically, the \eqn{j}th element is a vector of the judges' initial estimates of the calories in the \eqn{j}th meal.}
}

\describe{
\item{\code{E_CALORIES_FINAL}}{is a list of the judges' final estimates of the calorie counts in each of the 36 meals.
Specifically, the \eqn{j}th element is a vector of the judges' final estimates of the calories in the \eqn{j}th meal.}
}

\describe{
\item{\code{P_CALORIES}}{is a list of the judges' predictions of others.
Specifically, the \eqn{j}th element is a vector of the judges' predictions of other judges' average
estimate of the number of calories in the \eqn{j}th meal.}
}

\describe{
\item{\code{THETA_CALORIES}}{is a vector of the true calorie counts in each of the 36 meals.
Specifically, the \eqn{j}th element is the true calorie count in the \eqn{j}th meal.}
}

\describe{
\item{\code{ID_CALORIES}}{is a list of the judges' identification numbers in each of the 36 meals.
Specifically, the \eqn{j}th element is a vector of identification numbers of judges' who gave responses 
for the \eqn{j}th meal. These values make it possible to track a judge across questions.}
\item{\emph{Remark.}}{The elements of each list correspond to the same meal. Specifically, the \eqn{j}th elements of 
\code{THETA_CALORIES}, \code{E_CALORIES_INITIAL}, \code{E_CALORIES_FINAL}, \code{P_CALORIES}, and \code{ID_CALORIES}
 represent the true calories, initial estimates, final estimates, the predictions of others, and identification
 numbers of the \eqn{j}th meal.}
}
}
\source{
Asa Palley and Ville Satopää. "Boosting the Wisdom of Crowds Within a Single Judgment Problem:
Selective Averaging Based on Peer Predictions." \url{https://papers.ssrn.com/sol3/Papers.cfm?abstract_id=3504286}
}
\usage{
E_CALORIES_INITIAL

E_CALORIES_FINAL

P_CALORIES

THETA_CALORIES

ID_CALORIES
}
\description{
Palley and Satopää (2021) conducted an experiment where participants were presented with 36 different pictures
of food from different restaurants and were asked to estimate the total number of calories in these dishes.
Each response involves three steps:
\enumerate{
    \item \strong{Initial Estimates:} On the first screen the participant was presented with a picture of a meal
and asked \emph{How many calories do you think are in this meal?}
    \item \strong{Predictions of Others:} On the second screen the participant saw the same
picture, was reminded of their previous estimate, and given the statement:
\emph{We will be showing this picture to other participants as well. Just as we did with
you, we will ask them how many calories they believe are in this meal.}
The participant was then asked to predict \emph{How many calories do you think that others
will guess on average?}
    \item \strong{Final Estimates:} On the third screen the participant saw the same picture again
    and was asked \emph{After having reflected on others, what is
 your own final best estimate of the number of calories in this meal?}
}
}
\keyword{datasets}
