% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_filter_shared.R
\name{filter_shared}
\alias{filter_shared}
\title{filter_shared}
\usage{
filter_shared(spectral_count_object, metadata_feature)
}
\arguments{
\item{spectral_count_object}{List containing dataframes with proteomics
elements whose abundance is expressed as spectral counts and are
organized by peptides, subgroups, groups or taxonomic levels. 
The format of this object is similar to that generated from 
the functions "getsc_specific" and "crumble_taxonomy".}

\item{metadata_feature}{Character indicating the name of one explanatory 
variable (ONE column name) of the dataframe "metadata".}
}
\value{
A list defined as "spectral_count_object" in which 
   the elements (groups, subgroups, peptides or taxonomic levels) 
   of a given variable (condition or samples) from metadata 
   will have at least ONE spectra per variable.
}
\description{
Keeps the elements from a "spectral_count_object" that are common to all 
levels of a provided explanatory variable. This variable MUST correspond to 
the name of ONE column of the dataframe "metadata" (eg. conditions or samples). 
This function allows to identify the elements that are common to several 
conditions or samples.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
data(species_fw)

common_elements_per_sample <- filter_shared(fecal_waters, "SampleID")

common_elements_per_condition <- filter_shared(species_fw, "Condition")

\dontshow{setwd(.old_wd)}
}
