% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fronts.R
\name{calc_tfp}
\alias{calc_tfp}
\title{Thermic Front Parameter (TFP)}
\usage{
calc_tfp(t_fld, lev_p, lat = NULL, dx = 0.25, dy = 0.25, mode = "lonlat")
}
\arguments{
\item{t_fld}{temperature field [K]}

\item{lev_p}{vector containing pressure levels [Pa]}

\item{lat}{only for lonlat mode: vector containing latitude}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{mode}{the horizontal coordinate system, options are 'lonlat' for a longitude-latitude-grid (default), or 'cartesian' for an equidistant cartesian grid}
}
\value{
thermic front parameter [K/m^2]
}
\description{
Calculates the thermic front parameter based on the potential temperature
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
tfp=calc_tfp(data$temp,data$lev,data$lat)
}
