% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_operators.R
\name{df_dx}
\alias{df_dx}
\title{df_dx}
\usage{
df_dx(fld, lat = NULL, dx = 0.25, mode = "lonlat")
}
\arguments{
\item{fld}{field with dimensions (lon,lat,p)}

\item{lat}{only for lonlat mode: vector containing latitude}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{mode}{the coordinate system, options are lonlat for a longitude-latitude-grid (default), or cartesian for an equidistant cartesian grid}
}
\value{
field containing the partial derivative w.r.t. x
}
\description{
Calculates the x derivative using central differences (for lonlat-grid or cartesian grid)
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
theta=calc_theta(data$temp,data$lev)
dtheta_dx=df_dx(theta,data$lat)
}
