% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_operators.R
\name{grad}
\alias{grad}
\title{gradient of a scalar field}
\usage{
grad(
  fld,
  lat = NULL,
  d = 3,
  system = "p",
  rho = NULL,
  dx = 0.25,
  dy = 0.25,
  plev = 5000,
  mode = "lonlat"
)
}
\arguments{
\item{fld}{field with dimensions (lon,lat,p)}

\item{lat}{vector containing latitude}

\item{d}{scalar for dimension (use d=2 for horizontal gradient and d=3 for 3d-gradient)}

\item{system}{for type of coordinate system (use 'p' for pressure system and 'z' for height system)}

\item{rho}{field with dimensions (lon,lat,p) for density or a scalar rho (for constant density)}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{plev}{a scalar containing the p resolution (if equidistant) or a vector containing pressure levels in Pa (for non-equidistant)}

\item{mode}{the coordinate system, options are lonlat for a longitude-latitude-grid (default), or cartesian for an equidistant cartesian grid}
}
\value{
field containing the gradient with dimension (lon,lat,p,d)
}
\description{
Calculates the gradient
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
theta=calc_theta(data$temp,data$lev)
theta_grad=grad(theta,data$lat)
}
