% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standist.R
\name{mistr_d_p_q_r}
\alias{mistr_d_p_q_r}
\alias{mistr_d}
\alias{mistr_p}
\alias{mistr_q}
\alias{mistr_r}
\title{Mistr d/p/q/r Wrappers}
\usage{
mistr_d(O, x, log = FALSE)

mistr_p(O, q, lower.tail = TRUE, log.p = FALSE)

mistr_q(O, p, lower.tail = TRUE, log.p = FALSE, ...)

mistr_r(O, n)
}
\arguments{
\item{O}{distribution object.}

\item{x, q}{vector of quantiles.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{...}{further arguments to be passed.}

\item{n}{number of observations.}
}
\value{
Vector of computed results.
}
\description{
The functions \code{mistr_d}, \code{mistr_p}, \code{mistr_q}, \code{mistr_r} are wrappers
              for \code{\link{d}}, \code{\link{p}}, \code{\link{q}} and \code{\link{r}}, respectively.
}
\details{
Wrappers are offered as a consequence of R-Studio in Windows OS
         where the \code{q()} calls in the console are caught
         and terminate the \code{R} session.
}
