% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{new_dist}
\alias{new_dist}
\title{Creates New Distribution Object}
\usage{
new_dist(
  name,
  from,
  to,
  by = NULL,
  parameters = mget(names(eval(quote(match.call()), parent)[-1]), parent),
  class = deparse(sys.calls()[[sys.nframe() - 1]][[1]]),
  parent = parent.frame()
)
}
\arguments{
\item{name}{string containing the name of the distribution.}

\item{from}{numeric representing where the support of distribution starts.}

\item{to}{numeric representing where the support of distribution ends.}

\item{by}{numeric representing the deterministic step between support values.
If NULL: continuous distribution is assumed. If the value is specified: 
discrete distribution with specified step is assumed, default: NULL.}

\item{parameters}{named list of parameters of the distribution, default: mget(names(eval(quote(match.call()),parent)[-1]),parent).}

\item{class}{class of the distribution, this should be set in [name]dist convention (e.g. normdist, tdist), 
default: deparse(sys.calls()[[sys.nframe() - 1]][[1]]).}

\item{parent}{parent environment, default: parent.frame().}
}
\value{
distribution object.
}
\description{
The function creates distribution objects that satisfy the naming convention used in package mistr.
}
\details{
The function can be used in two ways. Either it can be called from the creator functions as for example 
         \code{\link{normdist}} or \code{\link{unifdist}}, or directly from any function or enviroment. In the former,
         only arguments "name", "from" and "to" must be set. Other arguments will be filled according to the parent calls.
          If this function is called directly, the arguments "parameters" and "class" have to be specified also.
}
\examples{
\dontrun{
# using creator function
unifdist <- function(min = 0, max = 1) { 
   if (!is.numeric(min) || !is.numeric(max))   stop("Parameters must be a numeric")
   if (min >= max)   stop("min must be smaller than max.")
   new_dist(name = "Uniform", from = min, to = max)
}

#directly
U <- new_dist(name = "Uniform", from = 1, to = 6, 
              parameters =  list(min = 1, max = 6), class = "unifdist")
}
}
