% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcut.R
\name{qcut}
\alias{qcut}
\title{Discretizing a numeric vector}
\usage{
qcut(x, n)
}
\arguments{
\item{x}{A numeric vector.}

\item{n}{An integer indicating the number of categories to discretize.}
}
\value{
A numeric vector to divide the vector x into n categories.
}
\description{
The function \code{qcut} discretizes a numeric vector into N pieces based 
on quantiles.
}
\examples{
x <- 1:10
# [1]  1  2  3  4  5  6  7  8  9 10
v <- qcut(1:10, 4)
# [1] 3 5 8
findInterval(x, sort(c(v, -Inf, Inf)), left.open = TRUE)
# [1] 1 1 1 2 2 3 3 3 4 4
}
