% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinkhorn.R
\name{sinkhorn_knopp}
\alias{sinkhorn_knopp}
\title{Sinkhorn--Knopp matrix scaling}
\usage{
sinkhorn_knopp(
  A,
  sums = rep(1, nrow(A)),
  niter = 100,
  tol = 1e-08,
  sym = FALSE,
  verb = FALSE
)
}
\arguments{
\item{A}{input matrix}

\item{sums}{desired row/column sums}

\item{niter}{number of iterations}

\item{tol}{convergence tolerance}

\item{sym}{whether to compute symmetric scaling D A D}

\item{verb}{whether to print the current change}
}
\value{
Diagonal matrices D1 and D2 to make D1\emph{A}D2 into a matrix with
given row/column sums.
}
\description{
Implements the Sinkhorn--Knopp algorithm for transforming a square matrix
with positive entries to a stochastic matrix with given common row and column
sums (e.g., a doubly stochastic matrix).
}
\details{
Computes diagonal matrices D1 and D2 to make D1\emph{A}D2 into a matrix with
given row/column sums. For a symmetric matrix \code{A}, one can set \code{sym = TRUE} to
compute a symmetric scaling D\emph{A}D.
}
\keyword{utils}
