% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.nn}
\alias{predict.nn}
\title{Neural network prediction}
\usage{
\method{predict}{nn}(object, newdata, rep = 1, all.units = FALSE, ...)
}
\arguments{
\item{object}{Neural network of class \code{nn}.}

\item{newdata}{New data of class \code{data.frame} or \code{matrix}.}

\item{rep}{Integer indicating the neural network's repetition which should be used.}

\item{all.units}{Return output for all units instead of final output only.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Matrix of predictions. Each column represents one output unit. 
If \code{all.units=TRUE}, a list of matrices with output for each unit.
}
\description{
Prediction of artificial neural network of class \code{nn}, produced by \code{neuralnet()}.
}
\examples{
library(neuralnet)

# Split data
train_idx <- sample(nrow(iris), 2/3 * nrow(iris))
iris_train <- iris[train_idx, ]
iris_test <- iris[-train_idx, ]

# Binary classification
nn <- neuralnet(Species == "setosa" ~ Petal.Length + Petal.Width, iris_train, linear.output = FALSE)
pred <- predict(nn, iris_test)
table(iris_test$Species == "setosa", pred[, 1] > 0.5)

# Multiclass classification
nn <- neuralnet((Species == "setosa") + (Species == "versicolor") + (Species == "virginica")
                 ~ Petal.Length + Petal.Width, iris_train, linear.output = FALSE)
pred <- predict(nn, iris_test)
table(iris_test$Species, apply(pred, 1, which.max))

}
\author{
Marvin N. Wright
}
