% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nevada-package.R
\docType{package}
\name{nevada-package}
\alias{nevada}
\alias{nevada-package}
\title{nevada: Network-Valued Data Analysis}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A flexible statistical framework for network-valued data analysis. It leverages the complexity of the space of distributions on graphs by using the permutation framework for inference as implemented in the 'flipr' package. Currently, only the two-sample testing problem is covered and generalization to k samples and regression will be added in the future as well. It is a 4-step procedure where the user chooses a suitable representation of the networks, a suitable metric to embed the representation into a metric space, one or more test statistics to target specific aspects of the distributions to be compared and a formula to compute the permutation p-value. Two types of inference are provided: a global test answering whether there is a difference between the distributions that generated the two samples and a local test for localizing differences on the network structure. The latter is assumed to be shared by all networks of both samples. References: Lovato, I., Pini, A., Stamm, A., Vantini, S. (2020) "Model-free two-sample test for network-valued data" \doi{10.1016/j.csda.2019.106896}; Lovato, I., Pini, A., Stamm, A., Taquet, M., Vantini, S. (2021) "Multiscale null hypothesis testing for network-valued data: Analysis of brain networks of patients with autism" \doi{10.1111/rssc.12463}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://astamm.github.io/nevada/}
  \item \url{https://github.com/astamm/nevada/}
  \item Report bugs at \url{https://github.com/astamm/nevada/issues/}
}

}
\author{
\strong{Maintainer}: Aymeric Stamm \email{aymeric.stamm@cnrs.fr} (\href{https://orcid.org/0000-0002-8725-3654}{ORCID})

Authors:
\itemize{
  \item Ilenia Lovato \email{ilenia.lovato01@universitadipavia.it}
  \item Alessia Pini \email{alessia.pini@unicatt.it}
  \item Simone Vantini \email{simone.vantini@polimi.it}
}

}
\keyword{internal}
