% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{power2}
\alias{power2}
\title{Power Simulations for Permutation Tests}
\usage{
power2(
  model1 = "gnp",
  model2 = "k_regular",
  n1 = 20L,
  n2 = 20L,
  num_vertices = 25L,
  model1_params = NULL,
  model2_params = NULL,
  representation = "adjacency",
  distance = "frobenius",
  stats = c("flipr:t_ip", "flipr:f_ip"),
  B = 1000L,
  alpha = 0.05,
  test = "exact",
  k = 5L,
  R = 1000L,
  seed = 1234
)
}
\arguments{
\item{model1}{A string specifying the model to be used for generating the
first sample. Choices are \code{"sbm"}, \code{"k_regular"}, \code{"gnp"}, \code{"smallworld"},
\code{"pa"}, \code{"poisson"} and \code{"binomial"}. Defaults to \code{"gnp"}.}

\item{model2}{A string specifying the model to be used for generating the
second sample. Choices are \code{"sbm"}, \code{"k_regular"}, \code{"gnp"}, \code{"smallworld"},
\code{"pa"}, \code{"poisson"} and \code{"binomial"}. Defaults to \code{"k_regular"}.}

\item{n1}{The size of the first sample. Defaults to \code{20L}.}

\item{n2}{The size of the second sample. Defaults to \code{20L}.}

\item{num_vertices}{The number of nodes in the generated graphs. Defaults to
\code{25L}.}

\item{model1_params}{A named list setting the parameters of the first chosen
model. Defaults to \code{list(p = 1/3)}.}

\item{model2_params}{A named list setting the parameters of the second chosen
model. Defaults to \code{list(k = 8L)}.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"} and \code{"modularity"}.
Defaults to \code{"adjacency"}.}

\item{distance}{A string specifying the chosen distance for calculating the
test statistic, among: \code{"hamming"}, \code{"frobenius"},
\code{"spectral"} and \code{"root-euclidean"}. Defaults to
\code{"frobenius"}.}

\item{stats}{A character vector specifying the chosen test statistic(s),
among: \code{"original_edge_count"}, \code{"generalized_edge_count"},
\code{"weighted_edge_count"}, \code{"student_euclidean"}, \code{"welch_euclidean"} or any
statistics based on inter-point distances available in the \strong{flipr}
package: \code{"flipr:student_ip"}, \code{"flipr:fisher_ip"}, \code{"flipr:bg_ip"},
\code{"flipr:energy_ip"}, \code{"flipr:cq_ip"}. Defaults to \code{c("flipr:student_ip", "flipr:fisher_ip")}.}

\item{B}{The number of permutation or the tolerance. If this number is lower
than \code{1}, it is intended as a tolerance. Otherwise, it is intended as
the number of required permutations. Defaults to \code{1000L}.}

\item{alpha}{Significance level for hypothesis testing. Defaults to \code{0.05}.}

\item{test}{A character string specifying the formula to be used to compute
the permutation p-value. Choices are \code{"estimate"}, \code{"upper_bound"} and
\code{"exact"}. Defaults to \code{"exact"} which provides exact tests.}

\item{k}{An integer specifying the density of the minimum spanning tree used
for the edge count statistics. Defaults to \code{5L}.}

\item{R}{Number of Monte-Carlo trials used to estimate the power. Defaults to
\code{1000L}.}

\item{seed}{An integer specifying the random generator seed. Defaults to
`1234.}
}
\value{
A numeric value estimating the power of the test.
}
\description{
This function provides a Monte-Carlo estimate of the power of the permutation
tests proposed in this package.
}
\details{
Currently, six scenarios of pairs of populations are implemented. Scenario 0
allows to make sure that all our permutation tests are exact.
}
\examples{
gnp_params <- list(p = 1/3)
k_regular_params <- list(k = 8L)
power2(
  model1_params = gnp_params,
  model2_params = k_regular_params,
  R = 10,
  B = 100,
  seed = 1234
)
}
