% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{test2_local}
\alias{test2_local}
\title{Local Two-Sample Test for Network-Valued Data}
\usage{
test2_local(
  x,
  y,
  partition,
  representation = "adjacency",
  distance = "frobenius",
  stats = c("flipr:t_ip", "flipr:f_ip"),
  B = 1000L,
  alpha = 0.05,
  test = "exact",
  k = 5L,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{Either an object of class \link{nvd} listing networks in sample 1 or a
distance matrix of size \eqn{n_1 + n_2}.}

\item{y}{Either an object of class \link{nvd} listing networks in sample 2 or an
integer value specifying the size of sample 1 or an integer vector
specifying the indices of the observations belonging to sample 1.}

\item{partition}{Either a list or an integer vector specifying vertex
memberships into partition elements.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"} and \code{"modularity"}.
Defaults to \code{"adjacency"}.}

\item{distance}{A string specifying the chosen distance for calculating the
test statistic, among: \code{"hamming"}, \code{"frobenius"},
\code{"spectral"} and \code{"root-euclidean"}. Defaults to
\code{"frobenius"}.}

\item{stats}{A character vector specifying the chosen test statistic(s),
among: \code{"original_edge_count"}, \code{"generalized_edge_count"},
\code{"weighted_edge_count"}, \code{"student_euclidean"}, \code{"welch_euclidean"} or any
statistics based on inter-point distances available in the \strong{flipr}
package: \code{"flipr:student_ip"}, \code{"flipr:fisher_ip"}, \code{"flipr:bg_ip"},
\code{"flipr:energy_ip"}, \code{"flipr:cq_ip"}. Defaults to \code{c("flipr:student_ip", "flipr:fisher_ip")}.}

\item{B}{The number of permutation or the tolerance. If this number is lower
than \code{1}, it is intended as a tolerance. Otherwise, it is intended as
the number of required permutations. Defaults to \code{1000L}.}

\item{alpha}{Significance level for hypothesis testing. If set to 1, the
function outputs properly adjusted p-values. If lower than 1, then only
p-values lower than alpha are properly adjusted. Defaults to \code{0.05}.}

\item{test}{A character string specifying the formula to be used to compute
the permutation p-value. Choices are \code{"estimate"}, \code{"upper_bound"} and
\code{"exact"}. Defaults to \code{"exact"} which provides exact tests.}

\item{k}{An integer specifying the density of the minimum spanning tree used
for the edge count statistics. Defaults to \code{5L}.}

\item{seed}{An integer for specifying the seed of the random generator for
result reproducibility. Defaults to \code{NULL}.}

\item{verbose}{Boolean specifying whether information on intermediate tests
should be printed in the process (default: \code{FALSE}).}
}
\value{
A length-2 list reporting the adjusted p-values of each element of
the partition for the intra- and inter-tests.
}
\description{
Local Two-Sample Test for Network-Valued Data
}
\examples{
n <- 5L
p1 <- matrix(
  data = c(0.1, 0.4, 0.1, 0.4,
           0.4, 0.4, 0.1, 0.4,
           0.1, 0.1, 0.4, 0.4,
           0.4, 0.4, 0.4, 0.4),
  nrow = 4,
  ncol = 4,
  byrow = TRUE
)
p2 <- matrix(
  data = c(0.1, 0.4, 0.4, 0.4,
           0.4, 0.4, 0.4, 0.4,
           0.4, 0.4, 0.1, 0.1,
           0.4, 0.4, 0.1, 0.4),
  nrow = 4,
  ncol = 4,
  byrow = TRUE
)
sim <- sample2_sbm(n, 68, p1, c(17, 17, 17, 17), p2, seed = 1234)
m <- as.integer(c(rep(1, 17), rep(2, 17), rep(3, 17), rep(4, 17)))
test2_local(sim$x, sim$y, m,
            seed = 1234,
            alpha = 0.05,
            B = 19)
}
