% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transparent.R
\name{Check_ACDE_bounds}
\alias{Check_ACDE_bounds}
\title{Bounds for the Average Controlled Direct Effect (ACDE).}
\usage{
Check_ACDE_bounds(n_y0x0z0, n_y1x0z0 = NA, n_y0x1z0 = NA, n_y1x1z0 = NA,
  n_y0x0z1 = NA, n_y1x0z1 = NA, n_y0x1z1 = NA, n_y1x1z1 = NA,
  iv.ineqs = FALSE)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.
Alternatively, a vector with elements
(either counts, p(y, x , z) or p(y, x | z)) in the order of the arguments.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x1z0}{Number of individuals with Y=0, X=1, Z=0.}

\item{n_y1x1z0}{Number of individuals with Y=1, X=1, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}

\item{iv.ineqs}{Whether to return the empirical bounds or
the IV inequalities (TRUE).}
}
\value{
The empirical bounds for the ACDE
   among Always Takers and Never Takers, or the
   empirical IV inequalities.
}
\description{
The empirical bounds for the Average Controlled Direct Effect (ACDE) within
   the principal strata of Always Takers and Never Takers,
   under the assumption of monotonicity (no Defiers).
   These are equivalent to an empirical check of the Instrumental Variable
   (IV) inequalities (see references below).
}
\examples{
Check_ACDE_bounds(99, 1027, 30, 233, 84, 935, 31, 422)
Check_ACDE_bounds(c(99, 1027, 30, 233, 84, 935, 31, 422))
Check_ACDE_bounds(99, 1027, 30, 233, 84, 935, 31, 422, iv.ineqs=TRUE)
Check_ACDE_bounds(c(99, 1027, 30, 233, 84, 935, 31, 422), iv.ineqs=TRUE)
}
\references{
{Richardson, T. S., Evans, R. J., & Robins, J. M. (2011).
   Transparent parameterizations of models for potential outcomes.
   \emph{Bayesian Statistics, 9, 569-610}.}

{A. Balke and J. Pearl. (1997).
   Bounds on treatment effects from studies with imperfect compliance.
   \emph{Journal of the American Statistical Association, 1171-1176}.}
}

