% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_pig.R
\name{order_pig}
\alias{order_pig}
\title{Random Sampling of k-th Order Statistics from a Poisson-inverse Gaussian Distribution}
\usage{
order_pig(size, k, mu, sigma, n, p = 0.5, alpha = 0.05, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{k}{numeric, represents the k-th smallest value from a sample.}

\item{mu}{numeric, represents the location parameter values.}

\item{sigma}{numeric, represents scale parameter values.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{p}{numeric, represents the 100p percentile for the distribution of the k-th order statistic. Default value is population median, p = 0.5.}

\item{alpha}{numeric, (1 - alpha) represents the confidence of an interval for the population percentile p of the distribution of the k-th order statistic. Default value is 0.05.}

\item{...}{represents others parameters of a Poisson-inverse Gaussian distribution.}
}
\value{
A list with a random sample of order statistics from a Poisson-inverse Gaussian Distribution, the value of its join probability density function evaluated in the random sample
and an approximate (1 - alpha) confidence interval for the population percentile p of the distribution of the k-th order statistic.
}
\description{
\code{order_pig} is used to obtain a random sample of the k-th order statistic from a Poisson-inverse Gaussian distribution and some associated quantities of interest.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Poisson-inverse Gaussian Distribution
# order_pig(size=20,k=5,mu=6,sigma=1,n=30,p=0.5,alpha=0.02)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Ribgy, R. and Stasinopoulos, M. (2005) Generalized Additive Models for Location Scale and Shape, Journal of the Royal Statistical Society. Applied Statistics, Series C.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
