% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genetic.optim.AIWKME.r
\name{Genetic.optim.AIWKME}
\alias{Genetic.optim.AIWKME}
\title{The optimal treatment regime based on the (S)AIWKME estimator.}
\usage{
Genetic.optim.AIWKME(datalist, ps, prep, t0, smooth = TRUE)
}
\arguments{
\item{datalist}{A list used to calculate the (S)AIWKME estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}. Notice that all the data in the datalist should be ordered by observed time.}

\item{ps}{A list including the probability of receiving treatment given baseline covariates named \code{fal}. \code{\link[otrKM]{Fps.AIWKME}} can produce \code{ps} by positing logistic model.}

\item{prep}{A list including the augmented terms in the numerator with treatment all to 1 named \code{gamma.num.1} and all to 0 named \code{gamma.num.0} and in the denominator with treatment all to 1 named \code{gamma.den.1} and all to 0 named \code{gamma.den.0}; \code{gamma.num.1} and the others are matrix with ordered observed time as rows and patients as columns. \code{\link[otrKM]{Fprep.AIWKME}} can produce \code{prep} by positing Cox proportional hazards model.}

\item{t0}{A predetermined time.}

\item{smooth}{A logic variable indicating wether a smoothed version should be used.}
}
\value{
A numeric vector in which the last number is the estimated optimal t0-year survival probability and others are the estimated parameters of the optimal treatment regime.
}
\description{
Given a predetermined t0, estimate the optimal treatment regime by maximizing t0-year survival probability based on the (S)AIWKME estimator.
}
\details{
More details can be found in references.
}
\examples{
# load data
data(simulation)
simulation=simulation[order(simulation$Survival),]

# convert the data into a datalist
datalist=list(z=simulation$Instrument,a=simulation$Treatment,
              obs.t=simulation$Survival,delta=simulation$Status,
              l=cbind(simulation$Covariate1,simulation$Covariate2))

# predetermined t0
t0=5

# calculate ps and prep
ps=Fps.AIWKME(datalist)
prep=Fprep.AIWKME(datalist, t0)

Genetic.optim.AIWKME(datalist, ps, prep, t0, smooth=TRUE)
}
\references{
{Jiang, R., Lu, W., Song, R., and Davidian, M. (2017) On estimation of optimal treatment regimes for maximizing t‐year survival probability. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, \bold{79:} 1165-1185. DOI:10.1111/rssb.12201}
}
