% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_ordinal_asymmetry.R
\encoding{UTF-8}
\name{ci_ordinal_asymmetry}
\alias{ci_ordinal_asymmetry}
\title{Constructs a confidence interval for the
ordinal asymmetry (block distance)}
\usage{
ci_ordinal_asymmetry(
  series,
  states,
  level = 0.95,
  temporal = TRUE,
  max_lag = 1
)
}
\arguments{
\item{series}{An OTS (numerical vector with integers).}

\item{states}{A numeric vector containing the corresponding
states.}

\item{level}{The confidence level (default is 0.95).}

\item{temporal}{Logical. If \code{temporal = TRUE} (default), the interval is computed for a time series. Otherwise,
the interval is computed for i.i.d. data.}

\item{max_lag}{If \code{temporal = TRUE}, the maximum considered lag to compute the
estimates related to the cumulative joint probabilities.}
}
\value{
The confidence interval.
}
\description{
\code{ci_ordinal_asymmetry} constructs a confidence interval for the
ordinal asymmetry (block distance)
}
\details{
If \code{temporal = TRUE} (default), the function constructs the confidence interval for the
ordinal asymmetry relying on Theorem 7.1.1 in \insertCite{weiss2019distance;textual}{otsfeatures}. Otherwise,
the interval is constructed according to Theorem 4.1 in \insertCite{weiss2019distance;textual}{otsfeatures}.
}
\examples{
ci_asymmetry <- ci_ordinal_asymmetry(AustrianWages$data[[100]],
states = 0 : 5) # Constructing a confidence interval for the
# ordinal asymmetry for one OTS in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
