\name{patchSynctex}
\alias{patchSynctex}
\title{Create correspondence between .pdf and .Rnw files}

\description{
\code{patchSynctex(foo)} uses the concordance file
\code{foo-concordance.tex} generated by \code{knit}ting (possibly
\code{Sweave}ing) \code{foo.Rnw} with the option \code{concordance=TRUE}
 to patch \code{foo.synctex(.gz)} with information pointing to
\code{foo.Rnw}.
}

\usage{
patchSynctex(nwfile, syncfile=NULL, verbose=FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{nwfile}{ name of the file to patch (used sans extension).  }
  \item{syncfile}{ output sync file (if nwfile is related to an included
    file). }
  \item{verbose}{ if TRUE, emit a message stating the number of
    patches. Useful for debugging integration in your tools. }
  \item{\dots}{
    Unused. Allows any argument forced by your tools to be passed
    without causing an error.
  }
}

\details{

  This function reads the information given in the
  \code{nwfile-concordance.tex} file (which \emph{must} exist) to patch
  the \code{nwfile.synctex(.gz)} file, which originally contains
  pointers from \code{nwfile.pdf} to the source in \code{nwfile.tex}
  with information pointing to the latter's source in \code{nwfile.Rnw}.

  Editors and viewers supporting Synctex will be able to use this
  information to allow forward- and backward search between PDF and ists
  original source, thus easing debugging.
  
  The \code{nwfile} will be used sans extension ; this allows your
  favorite IDE to pass either the name of the noweb file or the name of
  the .tex file.

  The \code{syncfile} argument allows to force the addition of the
  patched references to the main syncfile for a document that uses
  subfiles. This is a workaround that may or may not be well-supported
  by \code{knitr} and/or your viewer.

  The function may raise errors (files not found), warnings (no patch
  found to be done) or messages (number of patched locations).

  This function is principally intended for use by programmable IDEs able
  to execute \code{R} code. It is documented mostly for debugging
  purposes.

}

\value{Nothing useful.}

\references{
Duncan Murdoch's excellent \code{patchDVI} package:
  \url{https://cran.r-project.org/package=patchDVI}. 
}

\author{Jan Gleixner, Emmanuel Charpentier \email{emm.charpentier@free.fr}}

\note{ The current (1.8) version of \code{knitr} does not yet implement
concordance for multifile projects (i. e. children chunks). }

\examples{
if(requireNamespace("tools", quietly=TRUE) &&
   requireNamespace("knitr", quietly=TRUE)) {
    ## Minimal demonstrative knitr example.
    RnwSrc<-"
\\\\synctex=1
\\\\documentclass{article}
<<Setup, eval=TRUE, echo=FALSE, results='hide'>>=
opts_knit$set(concordance=TRUE, self.contained=TRUE)##$
require(patchSynctex)
@ 
\\\\author{A.~U.~Thor}
\\\\title{A minimal \\\\textsf{knitr} example}
\\\\date{Some time}
\\\\begin{document}
\\\\maketitle

A first paragraph of text, which offers a target for forward search\\\\,:
for example, in \\\\textsf{emacs} with \\\\textsf{AUCTeX}, typing
``C-c~C-v'' should bring you to your PDF viewer in the corresponding
typeset line.

<<TestFig, echo=FALSE>>=
curve(sin(x), from=-pi, to=pi, main='A curve generated by R',
      sub='back-searching from here should bring you close to the \\\\'TestFig\\\\' chunk.')
@ 

This second paragraph of text is also a convenient target for
back-searching. For example, in \\\\textsf{evince}, a ``<Ctrl>-click''
should bring you to the \\\\textsf{noweb} source, bypassing the \\\\LaTeX
intermediate file.
\\\\end{document}
"
    require(knitr)
    cat(RnwSrc, file="Minimal.Rnw")
    knit2pdf("Minimal.Rnw", quiet=TRUE)
    D1<-file.info("Minimal.synctex.gz")$mtime
    patchSynctex("Minimal", verbose=TRUE)
    ## should print a message telling the number of patches
    D2<-file.info("Minimal.synctex.gz")$mtime
    D1!=D2
    ## should return TRUE
    ## To see the effect, try (example on a Linux system)
    \dontrun{system("evince Minimal.pdf")}
}
}

\keyword{ ~interface }
\keyword{ ~documentation }% __ONLY ONE__ keyword per line
