% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/true_pairs_stsl.R
\name{true_pairs_stsl}
\alias{true_pairs_stsl}
\title{Expected number of true transmission pairs assuming single-transmission and single-linkage}
\usage{
true_pairs_stsl(eta, rho, M)
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}
}
\value{
scalar or vector giving the expected number of true transmission pairs in the sample
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the expected number of true transmission pairs in a sample of size \code{M}.
The single-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is linked by transmission to only one other case \eqn{j} in the population (\eqn{N}).
\item Each case \eqn{i} is linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}
}
\examples{
true_pairs_stsl(eta=0.95, rho=0.2, M=200)

}
\seealso{
Other true_pairs: 
\code{\link{true_pairs_mtml}()},
\code{\link{true_pairs_mtsl}()},
\code{\link{true_pairs}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{true_pairs}
