% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartrack_prob_detect_xsect.R
\name{vartrack_prob_detect_xsect}
\alias{vartrack_prob_detect_xsect}
\title{Calculate probability of detecting a variant assuming cross-sectional sampling}
\usage{
vartrack_prob_detect_xsect(p_v1, n, omega, c_ratio = 1)
}
\arguments{
\item{p_v1}{variant prevalence (proportion)}

\item{n}{sample size}

\item{omega}{probability of sequencing (or other characterization) success}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2. Default = 1 (no bias)}
}
\value{
scalar of expected sample size
}
\description{
This function calculates the probability of detecting the presence of a variant
given a sample size and assuming a single, cross-sectional sample of detected infections.
}
\examples{
vartrack_prob_detect_xsect(p_v1 = 0.02, n = 100, omega = 0.8, c_ratio = 1)

}
\seealso{
Other variant detection functions: 
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect_xsect}()},
\code{\link{vartrack_samplesize_detect}()}

Other variant tracking functions: 
\code{\link{vartrack_cod_ratio}()},
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_prob_prev}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect_xsect}()},
\code{\link{vartrack_samplesize_detect}()},
\code{\link{vartrack_samplesize_prev_xsect}()},
\code{\link{vartrack_samplesize_prev}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant detection functions}
\concept{variant tracking functions}
