% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_replace.R
\name{sprinkle_replace}
\alias{sprinkle_replace}
\alias{sprinkle_replace.default}
\alias{sprinkle_replace.dust_list}
\title{Replace Contents of Selected Cells}
\usage{
sprinkle_replace(
  x,
  rows = NULL,
  cols = NULL,
  replace,
  part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"),
  ...
)

\method{sprinkle_replace}{default}(
  x,
  rows = NULL,
  cols = NULL,
  replace,
  part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"),
  ...
)

\method{sprinkle_replace}{dust_list}(
  x,
  rows = NULL,
  cols = NULL,
  replace,
  part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{replace}{\code{character} A character vector giving the desired
content for the selected cells.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
At times it may be necessary to replace the contents of a 
cell with user-supplied values.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements \code{replace} column
   in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{replace} is not a vector
 \item Casts an warning if the number of indices to replace is not a 
   multiple of \code{replace} 
 \item Casts an error if \code{length(replace)} is greater than the 
   number of cells to replace.
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}

\seealso{
\code{\link{sprinkle}}, 
  \code{\link{index_to_sprinkle}}
}
