% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendAnalysis.R
\name{plot.trend}
\alias{plot.trend}
\title{Plot an estimated trend.}
\usage{
\method{plot}{trend}(
  x,
  ciBase = NULL,
  alpha = 0.05,
  ylab = "abundance index",
  trendCol = "black",
  lineCol = adjustcolor("black", alpha.f = 0.05),
  shadeCol = adjustcolor("#0072B2", alpha.f = 0.4),
  incCol = "#009E73",
  decCol = "#D55E00",
  plotGrid = TRUE,
  plotLines = FALSE,
  ranef = "pointCI",
  secDeriv = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted object of class trend.}

\item{ciBase}{A time point or function used to compute the baseline of the trend. 
If the argument is numeric, the point in the \var{trendGrid} argument of the function \code{\link{ptrend}}
closest to this value will be taken as the baseline (i.e. the estimated trend will be 1 at this point).
If the argument is a function, the function is applied to trends and the resulting value is used as the baseline.
By default, the first time point is taken as the reference.}

\item{alpha}{The alpha level of confidence intervals.}

\item{ylab}{The label of the y-axis.}

\item{trendCol}{The color of the trend line.}

\item{lineCol}{The color of bootstrapped trend lines, if plotted.}

\item{shadeCol}{The color of the confidence region.}

\item{incCol}{The color of regions where the first or second derivative is significantly increasing.}

\item{decCol}{The color of regions where the first or second derivative is significantly decreasing.}

\item{plotGrid}{If true, grid lines are plotted.}

\item{plotLines}{If true, the bootstrapped trends are plotted.}

\item{ranef}{String indicating whether to plot point estimates and/or confidence intervals for random effects. 
One of 'pointCI', 'point', 'CI' or 'no'.}

\item{secDeriv}{If true, coloured boxes at the bottom of the plot shows segments where the second derivative of the smooth is significantly different from zero.}

\item{...}{Further arguments passed to \code{\link[graphics]{plot.default}}.}
}
\description{
The function plots an estimated trend or index, as well as estimates of any temporal random effects included in the
trend term.
}
\details{
Trends and indexes are relative measures and therefore are compared against some reference value.
By default, the first observed time point is used as the reference value.

If the estimated trend contains bootstrap samples, confidence intervals are plotted as well.
For smooth trend models, time periods where the trend is significantly declining or increasing are marked with
a different color (set by arguments \var{decCol} and \var{incCol}). Periods where the second derivative is 
significantly positive or negative are marked by coloured boxes at the bottom of the plot. 


There is an additional option of plotting each of the bootstrapped trends.
}
\author{
Jonas Knape
}
