% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendAnalysis.R
\name{simTrend}
\alias{simTrend}
\title{Simulate population survey data.}
\usage{
simTrend(nyear = 30, nsite = 40, mu = 3, timeSD = 0.1, siteSD = 0.3)
}
\arguments{
\item{nyear}{The number of years in the simulated survey.}

\item{nsite}{The number of sites in the simulated survey}

\item{mu}{The expected mean of the counts at the start of the survey.}

\item{timeSD}{Standard deviation (at log-scale) of annual mean deviation from the trend.}

\item{siteSD}{Standard deviation (at log-scale) of simulated among site variation.}
}
\value{
A data frame containing simulated data.
}
\description{
Simulates count survey data with a non-linear trend, and site and temporal random effects. 
The logistic function is used to create a trend the reduces the expected population size to half 
its initial value over the time period.
}
\author{
Jonas Knape
}
