% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cALD_FamilyFunctions.R
\name{cALD}
\alias{cALD}
\title{Calculation of the \eqn{D'}, \eqn{Wn}, and conditional Asymmetric LD Measures}
\usage{
cALD(
  dataSet,
  inPhase = FALSE,
  verbose = TRUE,
  saveVector = FALSE,
  vectorName = "",
  vectorPrefix = "",
  vecDir = tempdir()
)
}
\arguments{
\item{dataSet}{A data frame or tab delimited file consisting of four columns of genotype data named, e.g. locus1_1 locus1_2 locus2_1 locus2_2, with 1 row per sample. The columns must be organized in this exact order, but the column names should not have _1 or _2 appended; use the same locus name for each column of a given locus. For phased data, locus1_1 is in phase with locus2_1, and locus1_2 is in phase with locus_2_2. Because this funciton operates on locus pairs, any rows with missing data should be excluded from the input genotype data.}

\item{inPhase}{A boolean identifying the genotyping data as phased or unphased (TRUE = phased; FALSE = unphased); default is unphased.}

\item{verbose}{A boolean identifying if results should be printed to the console (verbose = TRUE), or returned in a vector of (\eqn{D'}, \eqn{Wn}, \eqn{WLocus2/Locus1}, \eqn{WLocus1/Locus2}, number of haplotypes) (verbose = FALSE)}

\item{saveVector}{A boolean identifying if the vector of all haplotypes should be exported as a text file (saveVector = TRUE), or not (saveVector = FALSE).}

\item{vectorName}{A name for the exported haplotype vector file; this name is not used if saveVector = FALSE. If a name is unspecified, then a filename including the locus-pair and a timestamp is generated.}

\item{vectorPrefix}{An optional prefix for the haplotpe vector to be used if saveVector = TRUE. This prefix will be appended, along with the phase status, before the locus name and timestamp. LDWrap() uses this parameter to identify the dataset and haplotype information passed to cALD().}

\item{vecDir}{The directory into which the haplotype vector should be written if saveVector = TRUE. The default is the directory specified by tempdir().}
}
\value{
A vector of {D'}, {Wn}, {WLocus2/Locus1}, {WLocus1/Locus2} values, and the number of haplotypes evaluated
}
\description{
Calculates \eqn{D'}, \eqn{Wn} (Cramer's V) and Thomson and Single's conditional asymmetric LD (\eqn{ALD}) measures for pairs of loci.
}
\details{
LD results can be directed to the console or to a data file or data frame object. This function can generate a haplotype vector file for each locus pair analyzed, and will return the LD results eiher in the console, or as a data frame object.
The implementation of ALD applied here is calculated using individual \eqn{Dij} LD values and allele frequencies.
}
\examples{
# Analyze the first 10 rows of the included drb1.dqb1.demo genotype dataset
# and report LD results to the console.
cALD(drb1.dqb1.demo[1:10,])
# Alternatively, return a vector of LD results.
LDvec <- cALD(drb1.dqb1.demo[1:10,],verbose=FALSE)
}
\references{
Thomson G. & Single R.M. GENETICS 2014;198(1):321-31. https://doi.org/10.1534/genetics.114.165266
}
\keyword{ALD}
\keyword{asymmetric}
\keyword{cALD}
\keyword{conditional}
