% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDiffPlot.R
\name{makeDiffPlot}
\alias{makeDiffPlot}
\title{Plot individual differences between measured and predicted outcome values.}
\usage{
makeDiffPlot(xd = NULL, idCol = NULL)
}
\arguments{
\item{xd}{A data.frame with exactly two columns, one of the columns must be the identifier of all individuals, the other column must be the differences between the measured and the predicted outcome values.}

\item{idCol}{A single integer that denotes which of the columns of the data.frame contains the identifier of the individuals.}
}
\value{
a list with the plot that shows the differences between the measured and predicted outcome for all individuals. See \strong{Details}.
}
\description{
Plot the differences between measured and predicted outcome for all individuals.
}
\details{
The d in 'xd' stands for differences, meaning that the column of interest contain the differences between the measured and the predicted outcome values, logically requiring the column that identifies the individuals.

Irrespective of whether the original outcome was continuous or binary, outcome values always range between 0 and 100. For instance, for a binary outcome the 'probabilities' are represented as percentage.

Use the column diff (from function \code{\link{binContinuous}}) or diffPerc (from function \code{\link{binBinary}}) and column xAxisIds, both columns being part of both data.frames that are returned by the two mentioned functions.
}
\examples{
# Simulate data set with continuous outcome (use all default values)
dfContinuous <- quickSim()
# Use multiple linear regression as algorithm to predict the outcome.
lmRes <- lm(y~x1+x2,data=dfContinuous)
# Extract measured outcome and the predicted outcome (fitted values)
# from the regression output, put both in a data.frame.
lmDf <- data.frame(measOutcome=dfContinuous$y,
                   fitted=lmRes$fitted.values)
# Apply function binContinuous.
x100c <- binContinuous(x=lmDf, measColumn = 1, binWidth = 20)
# Apply function makeDiffPlot, using columns 5 and 6 from x100c[["xTrans"]]
# The second of columns 5 and 6 contains the identifiers of the individuals.
dp <- makeDiffPlot(x100c[["xTrans"]][,5:6], idCol = 2)
# dp is the plot that shows the individual differences.
# makeDiffPlot works the same way if binBinary had be used instead of
# binContinuous.
}
\references{
\insertRef{ggplot2Wickham}{predictMe}
}
\author{
Marcel Miché
}
