% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_res_labels}
\alias{m_add_res_labels}
\title{Add Residue Labels}
\usage{
m_add_res_labels(id, sel = m_sel(), style = m_style_label(), byframe)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{sel}{Atom selection specification}

\item{style}{Style spec to add to specified atoms}

\item{byframe}{if true, create labels for every individual frame, not just
current}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Add residue labels. This will generate one label per a
residue within the selected atoms. The label will be at the
centroid of the atoms and styled according to the passed style.
The label text will be \code{resn}\code{resi}
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(
    style = c(
      m_style_stick(radius = 0.15),
      m_style_cartoon()
    )
  ) \%>\%
  m_add_res_labels(
    sel = m_sel(resn = "GLY"),
    style = m_style_label(
      font = "Arial",
      fontColor = "white",
      backgroundColor = "black",
      showBackground = TRUE
    )
  ) \%>\%
  m_zoom_to()
}
